package com.patzn.lims.staff.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.staff.entity.LmsStaffEquip;
import com.patzn.lims.staff.service.ILmsStaffEquipService;
import com.patzn.lims.staff.vo.LmsStaffEquipVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 人员管理-人员关联检测仪器 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Api(description = "人员管理-人员关联检测仪器")
@RestController
@RequestMapping("/v1/staff_equip")
public class LmsStaffEquipController extends ServiceController<ILmsStaffEquipService,LmsStaffEquip> {

    @Autowired
    private ILmsStaffEquipService lmsStaffEquipService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsStaffEquipVO>> getPage(LmsStaffEquipVO lmsStaffEquipVO) {
        return success(lmsStaffEquipService.pageVO(getPage(), lmsStaffEquipVO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffEquipVO>> getList(LmsStaffEquipVO lmsStaffEquipVO) {
        return success(lmsStaffEquipService.listVO(lmsStaffEquipVO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsStaffEquipVO> getVO(@PathVariable("id") Long id) {
        return success(lmsStaffEquipService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffEquip lmsStaffEquip) {
        return success(lmsStaffEquipService.updateById(lmsStaffEquip));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsStaffEquip lmsStaffEquip) {
        return success(lmsStaffEquipService.save(lmsStaffEquip));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffEquipService.remove(Wrappers.<LmsStaffEquip>query().in("id", ids)));
	}

    @ApiOperation(value = "添加多个仪器", notes = "添加多个仪器")
    @PostMapping("/add")
    public PtResult<Boolean> addBatch(@RequestParam("equipId")Long[] equipId,@RequestParam("staffId")Long staffId) {

        return success(lmsStaffEquipService.addBatch(staffId,equipId));
    }

}
