package com.patzn.lims.staff.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.staff.entity.LmsStaffExperience;
import com.patzn.lims.staff.service.ILmsStaffExperienceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 工作经历 前端控制器
 * <p>
 *
 * @author XuTao
 * @since 2019-08-12
 */
@Api(description = "人员管理-工作经历")
@RestController
@RequestMapping("/v1/staff_experience")
public class LmsStaffExperienceController extends ServiceController<ILmsStaffExperienceService,LmsStaffExperience> {
    @Autowired
    private ILmsStaffExperienceService lmsStaffExperienceService;

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsStaffExperience lmsStaffExperience) {
        return success(lmsStaffExperienceService.add(lmsStaffExperience));
    }

    @ApiOperation(value = "删除", notes = "删除一条数据")
    @DeleteMapping("/")
    public PtResult<Boolean> del(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffExperienceService.remove(Wrappers.<LmsStaffExperience>query().in("id",ids)));
    }

    @ApiOperation(value = "根据id查询数据", notes = "添加一条数据")
    @GetMapping("/{id}")
    public PtResult<LmsStaffExperience> get(@PathVariable("id") Long id) {
        return success(lmsStaffExperienceService.getById(id));
    }

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsStaffExperience>> getPage(LmsStaffExperience lmsStaffExperience) {
        return success(lmsStaffExperienceService.page(getPage(), lmsStaffExperience));
    }




}
