package com.patzn.lims.staff.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipInfoDTO;
import com.patzn.lims.equip.vo.LmsEquipInfoVO;
import com.patzn.lims.staff.dto.LmsStaffInfoDTO;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffInfo;
import com.patzn.lims.staff.service.ILmsStaffFileService;
import com.patzn.lims.staff.service.ILmsStaffInfoService;
import com.patzn.lims.staff.vo.LmsStaffInfoVO;
import com.patzn.lims.staff.vo.LmsStaffTrainRecordVO;
import com.patzn.lims.sys.controller.SysOrgController;
import com.patzn.lims.sys.entity.SysOrg;
import com.patzn.lims.sys.service.ISysOrgService;
import com.patzn.lims.sys.vo.SysOrgVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 人员管理-人员基本信息 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Api(description = "人员管理-人员基本信息")
@RestController
@RequestMapping("/v1/staff_info")
public class LmsStaffInfoController extends ServiceController <ILmsStaffInfoService, LmsStaffInfo> {

    @Autowired
    private ILmsStaffInfoService lmsStaffInfoService;
    @Autowired
    private ILmsStaffFileService lmsStaffFileService;
    @Autowired
    private SysOrgController sysOrgClient;



    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsStaffInfoVO>> getPage(LmsStaffInfoVO lmsStaffInfoVO) {
        return success(lmsStaffInfoService.pageVO(getPage(), lmsStaffInfoVO));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffInfoVO>> getList(LmsStaffInfoVO lmsStaffInfoVO) {
        return success(lmsStaffInfoService.listVO(lmsStaffInfoVO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsStaffInfoVO> getVO(@PathVariable("id") Long id) {
        return success(lmsStaffInfoService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffInfoDTO lmsStaffInfoDTO) {
        return success(lmsStaffInfoService.edit(lmsStaffInfoDTO));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsStaffInfoDTO lmsStaffInfoDTO) {
       return success(lmsStaffInfoService.add(lmsStaffInfoDTO));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffInfoService.removeAllRel(ids));
    }

    @ApiOperation(value = "人员导入", notes = "人员导入数据内容")
    @PostMapping("/lms_staff_import")
    public PtResult<Boolean> importItem(MultipartFile file) {
        return success(lmsStaffInfoService.importItem(file));
    }


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsStaffFile> uploadFile(@RequestParam("file") MultipartFile file, Long relId, Integer type){
        return success(lmsStaffInfoService.uploadFile(file,relId,type));
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsStaffInfoService.deleteFile(id));
    }


    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsStaffFileService.downloadFile(id, response);
    }




    @ApiOperation(value = "添加临时数据", notes = "添加一条临时数据")
    @PostMapping("/temp")
    public PtResult<LmsStaffInfoVO> temp() {
        return success(lmsStaffInfoService.temp());
    }


    @ApiOperation(value = "得到组织机构下的人员", notes = "得到组织机构下的人员")
    @PostMapping("/org")
    public PtResult<Page<LmsStaffInfoVO>> getUserList(LmsStaffInfoVO lmsStaffInfo) {
       return success(lmsStaffInfoService.getListByOrg(getPage(),lmsStaffInfo));
    }

    @ApiOperation(value = "人员的培训记录", notes = "人员的培训记录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/pageEdu")
    public PtResult<Page<LmsStaffTrainRecordVO>> getEduList(LmsStaffTrainRecordVO lmsStaffTrainRecordVO) {
        return success(lmsStaffInfoService.getEduList(getPage(),lmsStaffTrainRecordVO));
    }



    @ApiOperation(value = "仪器分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/pageEq")
    public PtResult<Page<LmsEquipInfoVO>> getPage(LmsEquipInfoDTO lmsEquipInfoDTO) {
        return success(lmsStaffInfoService.pageEq(getPage(), lmsEquipInfoDTO));
    }


    @ApiOperation(value = "测试组织接口", notes = "测试组织接口")
    @PostMapping("/test")
    public PtResult<Page<SysOrgVO>> getList(Long id) {
        SysOrg org = new SysOrg();
        org.setId(id);
        return sysOrgClient.getPageJson(org);
    }


    @ApiOperation(value = "得到组织机构下的人员列表", notes = "得到组织机构下的人员列表")
    @PostMapping("/staffList")
    public PtResult<List<LmsStaffInfoVO>> getStaffList(LmsStaffInfoVO lmsStaffInfo) {
        return success(lmsStaffInfoService.getStaffList(lmsStaffInfo));
    }
}
