package com.patzn.lims.staff.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffProfessional;
import com.patzn.lims.staff.service.ILmsStaffFileService;
import com.patzn.lims.staff.service.ILmsStaffProfessionalService;
import com.patzn.lims.staff.vo.LmsStaffProfessionalVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 人员管理-人员职称 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Api(description = "人员管理-人员职称")
@RestController
@RequestMapping("/v1/staff_professional")
public class LmsStaffProfessionalController extends ServiceController<ILmsStaffProfessionalService,LmsStaffProfessional> {

    @Autowired
    private ILmsStaffProfessionalService lmsStaffProfessionalService;
    @Autowired
    private ILmsStaffFileService lmsStaffFileService;

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsStaffProfessionalVO>> getPage(LmsStaffProfessionalVO lmsStaffProfessionalVO) {
        return success(lmsStaffProfessionalService.pageVO(getPage(), lmsStaffProfessionalVO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffProfessionalVO>> getList(LmsStaffProfessionalVO lmsStaffProfessionalVO) {
        return success(lmsStaffProfessionalService.listVO(lmsStaffProfessionalVO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsStaffProfessionalVO> getVO(@PathVariable("id") Long id) {
        return success(lmsStaffProfessionalService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffProfessional lmsStaffProfessional) {
        return success(lmsStaffProfessionalService.updateById(lmsStaffProfessional));
	}




    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsStaffProfessionalVO lmsStaffProfessional) {
        return success(lmsStaffProfessionalService.add(lmsStaffProfessional));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffProfessionalService.del(ids));
	}

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsStaffFileService.downloadFile(id, response);
    }

    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsStaffFile> uploadFile(@RequestParam("file") MultipartFile file, Long relId, Integer type){
        return success(lmsStaffProfessionalService.uploadFile(file,relId,type));
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsStaffProfessionalService.deleteFile(id));
    }



    @ApiOperation(value = "添加临时数据", notes = "添加一条临时数据")
    @PostMapping("/temp")
    public PtResult<LmsStaffProfessionalVO> temp() {
        return success(lmsStaffProfessionalService.temp());
    }



}
