package com.patzn.lims.staff.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.staff.entity.LmsStaffStatus;
import com.patzn.lims.staff.service.ILmsStaffStatusService;
import com.patzn.lims.staff.vo.LmsStaffStatusRecordVO;
import com.patzn.lims.staff.vo.LmsStaffStatusVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 人员管理-人员状态 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Api(description = "人员管理-人员状态")
@RestController
@RequestMapping("/v1/staff_status")
public class LmsStaffStatusController extends ServiceController <ILmsStaffStatusService,LmsStaffStatus> {

    @Autowired
    private ILmsStaffStatusService lmsStaffStatusService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsStaffStatusVO>> getPage(LmsStaffStatusVO lmsStaffStatusVO) {
        return success(lmsStaffStatusService.pageVO(getPage(), lmsStaffStatusVO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffStatusVO>> getList(LmsStaffStatusVO lmsStaffStatusVO) {
        return success(lmsStaffStatusService.listVO(lmsStaffStatusVO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsStaffStatusVO> getVO(@PathVariable("id") Long id) {
        return success(lmsStaffStatusService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffStatus lmsStaffStatus) {
        return success(lmsStaffStatusService.updateStaffStatus(lmsStaffStatus));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsStaffStatus lmsStaffStatus) {
        return success(lmsStaffStatusService.add(lmsStaffStatus));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffStatusService.remove(Wrappers.<LmsStaffStatus>query().in("id", ids)));
	}

    @ApiOperation(value = "查询日历列表", notes = "查询日历列表")
    @PostMapping("/calendarList")
    public PtResult<List<LmsStaffStatusVO>> getCalendarList(LmsStaffStatusVO lmsStaffStatusVO) {
        return success(lmsStaffStatusService.calendarList(lmsStaffStatusVO));
    }


    @ApiOperation(value = "分页查询人员状态操作记录表", notes = "分页查询人员状态操作记录表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/pageRecord")
    public PtResult<IPage<LmsStaffStatusRecordVO>> getRecordPage(LmsStaffStatusRecordVO lmsStaffStatusRecordVO) {
        return success(lmsStaffStatusService.pageStaffStatusRecordVO(getPage(), lmsStaffStatusRecordVO));
    }


}
