package com.patzn.lims.staff.controller;
import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.cloud.commons.toolkit.UploadUtils;
import com.patzn.lims.staff.entity.LmsStaffTrainPlan;
import com.patzn.lims.staff.entity.LmsStaffTrainPlanAttachment;
import com.patzn.lims.staff.service.ILmsStaffTrainPlanAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 人员培训计划附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-20
 */
@Api(description = "人员培训计划附件表")
@RestController
@RequestMapping("/v1/staff_train_plan_attachment")
public class LmsStaffTrainPlanAttachmentController extends ServiceController<ILmsStaffTrainPlanAttachmentService,LmsStaffTrainPlanAttachment> {

    @Autowired
    private ILmsStaffTrainPlanAttachmentService lmsStaffTrainPlanAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsStaffTrainPlanAttachment>> getPage(LmsStaffTrainPlanAttachment lmsStaffTrainPlanAttachment) {
        return success(lmsStaffTrainPlanAttachmentService.page(getPage(), lmsStaffTrainPlanAttachment));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffTrainPlanAttachment>> getList(LmsStaffTrainPlanAttachment lmsStaffTrainPlanAttachment) {
        return success(lmsStaffTrainPlanAttachmentService.list(lmsStaffTrainPlanAttachment));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsStaffTrainPlanAttachment> get(@PathVariable("id") Long id) {
        return success(lmsStaffTrainPlanAttachmentService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffTrainPlanAttachment lmsStaffTrainPlanAttachment) {
        lmsStaffTrainPlanAttachment.setId(id);
        return success(lmsStaffTrainPlanAttachmentService.updateById(lmsStaffTrainPlanAttachment));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsStaffTrainPlanAttachment lmsStaffTrainPlanAttachment) {
        return success(lmsStaffTrainPlanAttachmentService.save(lmsStaffTrainPlanAttachment));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffTrainPlanAttachmentService.remove(Wrappers.<LmsStaffTrainPlanAttachment>query().in("id", ids)));
	}



    @ApiOperation(value = "上传人员培训计划附件", notes = "上传人员培训计划附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "trainPlanId", value = "人员培训计划 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{trainPlanId}")
    public PtResult<Boolean> uploadAttachment(@PathVariable("trainPlanId") Long trainPlanId, MultipartHttpServletRequest mhsr) {
        if (UploadUtils.resumeUpload(request)) {
            return null;
        }
        Iterator<String> fns = mhsr.getFileNames();
        while (fns.hasNext()) {
            // 获取上传的文件列表
            return success(lmsStaffTrainPlanAttachmentService.save(trainPlanId, mhsr.getFile(fns.next())));
        }
        return success(false);
    }


    @ApiOperation(value = "下载人员培训计划附件", notes = "根据 id 下载人员培训计划附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        lmsStaffTrainPlanAttachmentService.download(id, response);
    }




    @ApiOperation(value = "上传附件(新)", notes = "上传附件（新）")
    @PostMapping("/uploadFile")
    public PtResult<LmsStaffTrainPlanAttachment> upload(@RequestParam("file") MultipartFile file, LmsStaffTrainPlan plan) {
        return success(lmsStaffTrainPlanAttachmentService.saveAndUpload( file, plan));
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsStaffTrainPlanAttachmentService.deleteFile(id));
    }


}
