package com.patzn.lims.staff.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.staff.entity.LmsStaffTrainPlan;
import com.patzn.lims.staff.service.ILmsStaffTrainPlanService;
import com.patzn.lims.staff.vo.LmsStaffTrainPlanVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 人员管理-人员培训计划 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Api(description = "人员管理-人员培训计划")
@RestController
@RequestMapping("/v1/staff_train_plan")
public class LmsStaffTrainPlanController extends ServiceController <ILmsStaffTrainPlanService,LmsStaffTrainPlan> {

    @Autowired
    private ILmsStaffTrainPlanService lmsStaffTrainPlanService;

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsStaffTrainPlanVO>> getPage(LmsStaffTrainPlan lmsStaffTrainPlan) {
        return success(lmsStaffTrainPlanService.page(getPage(), lmsStaffTrainPlan));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffTrainPlan>> getList(LmsStaffTrainPlan lmsStaffTrainPlan) {
        return success(lmsStaffTrainPlanService.list(lmsStaffTrainPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsStaffTrainPlan> get(@PathVariable("id") Long id) {
        return success(lmsStaffTrainPlanService.getById(id));
    }

    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/plan/{id}")
    public PtResult<LmsStaffTrainPlanVO> getPlanInfo(@PathVariable("id") Long id) {
        return success(lmsStaffTrainPlanService.getPlanInfo(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffTrainPlan lmsStaffTrainPlan) {
        return success(lmsStaffTrainPlanService.edit(lmsStaffTrainPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsStaffTrainPlan lmsStaffTrainPlan) {
        lmsStaffTrainPlan.setCompactor(getAccount().getUserName());
        return success(lmsStaffTrainPlanService.add(lmsStaffTrainPlan));
    }

    @ApiOperation(value = "直接提交", notes = "直接提交")
    @PostMapping("/commit")
    public PtResult<Boolean> commit(LmsStaffTrainPlan lmsStaffTrainPlan) {
        return success(null != lmsStaffTrainPlanService.commit(lmsStaffTrainPlan, getAccount()));
    }


    @ApiOperation(value = "培训计划提交至审批", notes = "培训计划提交至审批")
    @PostMapping("/submit_flow")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(null != lmsStaffTrainPlanService.submitCheckFlow(ids, getAccount()));
    }

    @ApiOperation(value = "审批操作", notes = "审批操作")
    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsStaffTrainPlanService.approveFlow(taskId, status, reason));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffTrainPlanService.remove(Wrappers.<LmsStaffTrainPlan>query().in("id", ids)));
    }


    @ApiOperation(value = "添加临时数据", notes = "添加一条临时数据")
    @PostMapping("/temp")
    public PtResult<LmsStaffTrainPlanVO> temp() {
        return success(lmsStaffTrainPlanService.temp());
    }

}
