package com.patzn.lims.staff.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.cloud.commons.toolkit.UploadUtils;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordAttachment;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 人员培训记录附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-17
 */
@Api(description = "人员培训记录附件表")
@RestController
@RequestMapping("/v1/staff_train_record_attachment")
public class LmsStaffTrainRecordAttachmentController extends ServiceController<ILmsStaffTrainRecordAttachmentService,LmsStaffTrainRecordAttachment> {

    @Autowired
    private ILmsStaffTrainRecordAttachmentService lmsStaffTrainRecordAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsStaffTrainRecordAttachment>> getPage(LmsStaffTrainRecordAttachment lmsStaffTrainRecordAttachment) {
        return success(lmsStaffTrainRecordAttachmentService.page(getPage(), lmsStaffTrainRecordAttachment));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffTrainRecordAttachment>> getList(LmsStaffTrainRecordAttachment lmsStaffTrainRecordAttachment) {
        return success(lmsStaffTrainRecordAttachmentService.list(lmsStaffTrainRecordAttachment));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsStaffTrainRecordAttachment> get(@PathVariable("id") Long id) {
        return success(lmsStaffTrainRecordAttachmentService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffTrainRecordAttachment lmsStaffTrainRecordAttachment) {
        lmsStaffTrainRecordAttachment.setId(id);
        return success(lmsStaffTrainRecordAttachmentService.updateById(lmsStaffTrainRecordAttachment));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsStaffTrainRecordAttachment lmsStaffTrainRecordAttachment) {
        return success(lmsStaffTrainRecordAttachmentService.save(lmsStaffTrainRecordAttachment));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffTrainRecordAttachmentService.remove(Wrappers.<LmsStaffTrainRecordAttachment>query().in("id", ids)));
	}


    @ApiOperation(value = "上传人员培训记录附件", notes = "上传人员培训记录附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "recordId", value = "人员培训记录 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{recordId}")
    public PtResult<Boolean> uploadAttachment(@PathVariable("recordId") Long certificateId, MultipartHttpServletRequest mhsr) {
        if (UploadUtils.resumeUpload(request)) {
            return null;
        }
        Iterator<String> fns = mhsr.getFileNames();
        while (fns.hasNext()) {
            // 获取上传的文件列表
            return success(lmsStaffTrainRecordAttachmentService.save(certificateId, mhsr.getFile(fns.next())));
        }
        return success(false);
    }


    @ApiOperation(value = "下载人员培训记录附件", notes = "根据 id 下载人员培训记录附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        lmsStaffTrainRecordAttachmentService.download(id, response);
    }


}
