package com.patzn.lims.staff.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.staff.entity.LmsStaffTrainRecord;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordAttachment;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordLog;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordAttachmentService;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordLogService;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordService;
import com.patzn.lims.staff.vo.LmsStaffTrainRecordVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;


/**
 * <p>
 * 人员管理-人员培训记录 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Api(description = "人员管理-人员培训记录")
@RestController
@RequestMapping("/v1/staff_train_record")
public class LmsStaffTrainRecordController extends ServiceController <ILmsStaffTrainRecordService,LmsStaffTrainRecord> {

    @Autowired
    private ILmsStaffTrainRecordService lmsStaffTrainRecordService;
    @Autowired
    private ILmsStaffTrainRecordLogService lmsStaffTrainRecordLogService;
    @Autowired
    private ILmsStaffTrainRecordAttachmentService lmsStaffTrainRecordAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsStaffTrainRecordVO>> getPage(LmsStaffTrainRecordVO lmsStaffTrainRecordVO) {
        return success(lmsStaffTrainRecordService.pageVO(getPage(), lmsStaffTrainRecordVO));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffTrainRecordVO>> getList(LmsStaffTrainRecordVO lmsStaffTrainRecordVO) {
        return success(lmsStaffTrainRecordService.listVO(lmsStaffTrainRecordVO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsStaffTrainRecordVO> getVO(@PathVariable("id") Long id) {
        return success(lmsStaffTrainRecordService.getVOById(id));

    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffTrainRecord lmsStaffTrainRecord) {
        return success(lmsStaffTrainRecordService.edit(lmsStaffTrainRecord));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsStaffTrainRecord lmsStaffTrainRecord) {
        lmsStaffTrainRecord.setStatus(0);
        lmsStaffTrainRecord.setTemp(1);
        return success(lmsStaffTrainRecordService.add(lmsStaffTrainRecord));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffTrainRecordService.remove(Wrappers.<LmsStaffTrainRecord>query().in("id", ids)));
    }

    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsStaffTrainRecordAttachment> upload(@RequestParam("file") MultipartFile file, LmsStaffTrainRecord record) {
        return success(lmsStaffTrainRecordService.uploadAttachment("lims", file, record));
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsStaffTrainRecordService.deleteFile(id));
    }


    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsStaffTrainRecordAttachmentService.download(id, response);
    }




    @ApiOperation(value = "导出培训计划的培训记录", notes = "导出培训计划的培训记录")
    @GetMapping("/train_plan_record_export")
    public void exportPersonTrain(@RequestParam("id") String id) {
        if (null != id) {
            lmsStaffTrainRecordService.exportPersonTrain(response, Long.valueOf(id));
        }
    }


    @ApiOperation(value = "导出人员的的培训记录", notes = "导出培训计划的培训记录")
    @PostMapping("/person_train_record_export")
    public void exportPersonSelfTrain(@RequestParam("id") Long id) {
        if (null != id) {
            lmsStaffTrainRecordService.exportPersonSelfTrain(response, id);
        }
    }


    @ApiOperation(value = "确认培训记录", notes = "确认培训记录")
    @PostMapping("/entrue")
    public PtResult<Boolean> entrue(LmsStaffTrainRecord lmsStaffTrainRecord) {
        lmsStaffTrainRecord.setStatus(2);
        lmsStaffTrainRecord.setConfirmor(getAccount().getUserName());
        lmsStaffTrainRecord.setConfirTime(new Date());
        LmsStaffTrainRecordLog log = new LmsStaffTrainRecordLog();
        log.setRecordId(lmsStaffTrainRecord.getId());
        log.setType(0);
        log.setOperator(getAccount().getUserName());
        log.setTarget("确认培训记录");
        log.setLiable(getAccount().getUserName());
        lmsStaffTrainRecordLogService.save(log);
        return success(lmsStaffTrainRecordService.updateById(lmsStaffTrainRecord));
    }


    @ApiOperation(value = "提交至审阅", notes = "提交至审阅")
    @PostMapping("/submit/{id}")
    public PtResult<Boolean> submit(@PathVariable("id") Long id, LmsStaffTrainRecord lmsStaffTrainRecord) {
        lmsStaffTrainRecord.setId(id);
        lmsStaffTrainRecord.setStatus(1);
        lmsStaffTrainRecord.setTemp(1);
        //历史
        if (lmsStaffTrainRecord.getId() != null) {
            LmsStaffTrainRecordLog log = new LmsStaffTrainRecordLog();
            log.setRecordId(lmsStaffTrainRecord.getId());
            log.setType(0);
            log.setOperator(getAccount().getUserName());
            log.setTarget("提交至审阅");
            log.setLiable(getAccount().getUserName());
            lmsStaffTrainRecordLogService.save(log);
        }
        return success(lmsStaffTrainRecordService.updateById(lmsStaffTrainRecord));
    }

    @ApiOperation(value = "提交", notes = "提交")
    @PostMapping("/commit")
    public PtResult<Boolean> submit(Long id) {
        LmsStaffTrainRecord lmsStaffTrainRecord = new LmsStaffTrainRecord();
        lmsStaffTrainRecord.setId(id);
        lmsStaffTrainRecord.setStatus(1);
        LmsStaffTrainRecordLog log = new LmsStaffTrainRecordLog();
        log.setRecordId(lmsStaffTrainRecord.getId());
        log.setType(0);
        log.setOperator(getAccount().getUserName());
        log.setTarget("提交至审阅");
        log.setLiable(getAccount().getUserName());
        lmsStaffTrainRecordLogService.save(log);
        return success(lmsStaffTrainRecordService.updateById(lmsStaffTrainRecord));
    }


    @ApiOperation(value = "添加临时数据", notes = "添加一条临时数据")
    @GetMapping("/temp")
    public PtResult<LmsStaffTrainRecordVO> temp() {
        return success(lmsStaffTrainRecordService.temp());
    }
}
