package com.patzn.lims.staff.dto;

import com.patzn.lims.staff.entity.LmsStaffInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 人员管理-人员基本信息
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffInfoDTO extends LmsStaffInfo {

	@ApiModelProperty(value = "机构 ID 集合 ， 逗号分割")
	private String orgIds;

	public List<Long> orgIdList() {
		if (StringUtils.isEmpty(this.orgIds)) {
			return null;
		}
		String[] orgIdArr = this.orgIds.split(",");
		List<Long> orgIdList = new ArrayList<>();
		for (String orgId : orgIdArr) {
			orgIdList.add(Long.valueOf(orgId));
		}
		return orgIdList;
	}
	@ApiModelProperty(value = "附件集合")
	private String fileIds;

	public List<Long> fileIdList() {
		if (StringUtils.isEmpty(this.fileIds)) {
			return null;
		}
		String[] fileIdArr = this.fileIds.split(",");
		List<Long> fileIdList = new ArrayList<>();
		for (String fileId : fileIdArr) {
			fileIdList.add(Long.valueOf(fileId));
		}
		return fileIdList;
	}
}
