package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.util.Date;
/**
 * <p>
 * 人员证书表
 * </p>
 *
 * @author patzn
 * @since 2018-06-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffCertificate extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "人员id")
	private Long staffId;

    @ApiModelProperty(value = "证书名称")
	private String name;

    @ApiModelProperty(value = "证书日期")
	private Date certificateDate;

    @ApiModelProperty(value = "有效日期")
	private Date effectiveDate;

    @ApiModelProperty(value = "证书编号")
	private String certificateNum;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建日期")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "预警期")
	private Integer warning;

}
