package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 人员管理文件信息表
 * </p>
 *
 * @author patzn
 * @since 2018-05-15
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffFile extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "关联id")
	private Long relId;

    @ApiModelProperty(value = "文件类型（0培训）")
	private Integer type;

    @ApiModelProperty(value = "文件云url")
	private String fileUrl;

    @ApiModelProperty(value = "文件原名")
	private String fileOrginName;

	@ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;


}
