package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 人员管理-人员基本信息
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffInfo extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "等级id")
	private Long levelId;

    @ApiModelProperty(value = "工号")
	private String number;

    @ApiModelProperty(value = "姓名")
	private String name;

	@ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "年龄")
    private Integer age;

	@ApiModelProperty(value = "入职时间")
	private Date entryTime;

	@ApiModelProperty(value = "参加工作时间")
	private Date workTime;

	@ApiModelProperty(value = "专业")
	private String profession;

	@ApiModelProperty(value = "学历")
	private String education;

	@ApiModelProperty(value = "毕业时间")
	private Date graduationTime;

	@ApiModelProperty(value = "毕业院校")
	private String graduatedSchool;

	@ApiModelProperty(value = "岗位")
	private String post;

	@ApiModelProperty(value = "状态(0离职，1在职)")
	private Integer status;

	@ApiModelProperty(value = "是否内审(0否，1是)")
	private Integer ifAuditor;

	@ApiModelProperty(value = "性别")
	private Integer sex;


	@ApiModelProperty(value = "是否删除")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "试用期开始时间")
	private Date probatioStartDate ;

	@ApiModelProperty(value = "试用期结束时间")
	private Date probatioEndDate ;

	@ApiModelProperty(value = "合同到期时间")
	private Date expireDate ;

	@ApiModelProperty(value = "入职转正时间")
	private Date becomeDate ;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;


	@ApiModelProperty(value = "uid")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
}
