package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 人员管理-人员等级分类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffLevel extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "上级id")
	private Long pid;

    @ApiModelProperty(value = "等级名称")
	private String name;

    @ApiModelProperty(value = "编号 ")
	private String code;

	@ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;


	@ApiModelProperty(value = "是否删除")
	@TableLogic
	private Integer deleted;


}
