package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 人员管理-人员职称
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffProfessional extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "员工id")
	private Long staffId;

    @ApiModelProperty(value = "职称名称")
	private String name;

    @ApiModelProperty(value = "有效期-开始")
	private Date startDate;

    @ApiModelProperty(value = "有效期-结束")
	private Date endDate;

	@ApiModelProperty(value = "证件号")
	private String licenseNumber;

	@ApiModelProperty(value = "发证机关号")
	private String issuingAuthority;

	@ApiModelProperty(value = "预警期")
	private Integer warningPeriod;

	@ApiModelProperty(value = "备注")
	private String remark;


	@ApiModelProperty(value = "级别")
	private String level;


	@ApiModelProperty(value = "是否删除0否1是")
	@TableLogic
	private Integer deleted;



}
