package com.patzn.lims.staff.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 人员管理-人员排班
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffSchedule extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "人员id")
	private Long staffId;

    @ApiModelProperty(value = "排班班次(0早班，1中班，2晚班)")
	private Integer shift;

	@ApiModelProperty(value = "排班开始日期")
	private Date scheduleStartTime;

	@ApiModelProperty(value = "排班结束日期")
	private Date scheduleEndTime;

	@ApiModelProperty(value = "排班开始时间")
	private String scheduleStartTimeHms;

	@ApiModelProperty(value = "排班结束时间")
	private String scheduleEndTimeHms;

    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;


}
