package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 人员管理-人员状态
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffStatus extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "员工id")
	private Long staffId;

	@ApiModelProperty(value = "工作日期")
	private Date workDate;

    @ApiModelProperty(value = "字典")
	private Long status;

    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
}
