package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 人员管理-人员任务
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffTask extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "人员id")
	private Long staffId;

    @ApiModelProperty(value = "任务名称")
	private String name;

    @ApiModelProperty(value = "任务日期")
	private Date taskDate;

    @ApiModelProperty(value = "内容描述")
	private String remark;

	@ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;


	@ApiModelProperty(value = "是否删除0否，1是")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;


	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "任务开始时间")
	private Date beginDate;

	@ApiModelProperty(value = "任务结束时间")
	private Date endDate;

}
