package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.staff.enums.StaffTrainPlanEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 人员管理-人员培训计划
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffTrainPlan extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "培训名称")
    private String name;

    @ApiModelProperty(value = "培训类型（字典）")
    private Long type;

    @ApiModelProperty(value = "负责人id")
    private Long charger;

    @ApiModelProperty(value = "负责人姓名")
    private String chargerName;

    @ApiModelProperty(value = "培训人员id")
    private String staffIds;

    @ApiModelProperty(value = "培训人员姓名")
    private String staffNames;

    @ApiModelProperty(value = "培训日期")
    private Date trainDate;

    @ApiModelProperty(value = "提前提醒天数")
    private Integer warnDays;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "状态")
    private Integer status;

    @ApiModelProperty(value = "进度")
    private Integer progress;

    @ApiModelProperty(value = "编制人id")
    @TableField(fill = FieldFill.INSERT)
    private Long compactorId;

    @ApiModelProperty(value = "编制人")
    @TableField(fill = FieldFill.INSERT)
    private String compactor;

    @ApiModelProperty(value = "编制时间")
    @TableField(fill = FieldFill.INSERT)
    private Date compacteDate;

    @ApiModelProperty(value = "批准人id")
    private Long approverId;

    @ApiModelProperty(value = "批准人")
    private String approver;

    @ApiModelProperty(value = "批准时间")
    private Date approvDate;

    @ApiModelProperty(value = "申请人id")
    private Long applyId;

    @ApiModelProperty(value = "申请人")
    private String applyName;

    @ApiModelProperty(value = "申请时间")
    private Date applyDate;

    @ApiModelProperty(value = "批准意见")
    private String approverOpinion;

    @ApiModelProperty(value = "培训计划")
    private String trainPlan;

    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "创建人id")
    private Long userId;

    @ApiModelProperty(value = "创建人姓名")
    private String userName;


    @ApiModelProperty(value = "是否删除0否，1是")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty(value = "最后修改人id")
    @TableField(fill = FieldFill.UPDATE)
    private Long lid;

    @ApiModelProperty(value = "最后修改时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date ltime;


    @ApiModelProperty(value = "创建人id")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "任务开始时间")
    private Date beginDate;

    @ApiModelProperty(value = "任务结束时间")
    private Date endDate;

    @ApiModelProperty(value = "考核办法 字典")
    private Long assessmentMethod;



    @ApiModelProperty(value = "培训目标")
    private String trainAim;

    @ApiModelProperty(value = "培训内容")
    private String trainContent;

    @ApiModelProperty(value = "Temp")
    private Integer temp;




    public List<Long> staffIdList() {
        List<Long> listIds = Arrays.asList(this.staffIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());

        return listIds;
    }
}
