package com.patzn.lims.staff.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 人员管理-人员培训记录
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffTrainRecord extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "培训计划id")
	private Long trainId;

    @ApiModelProperty(value = "实到人员id")
	private String staffedIds;

	@ApiModelProperty(value = "实到人员姓名")
    private String staffedNames;

    @ApiModelProperty(value = "总结")
	private String summary;

    @ApiModelProperty(value = "附件（文件路径）")
	private String attachment;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "培训科室")
	private String trainDepartment;

	@ApiModelProperty(value = "培训内容及目标")
	private String contentAim;

	@ApiModelProperty(value = "人数")
	private Integer personQuantity;

	@ApiModelProperty(value = "学时")
	private Integer learnHour;

	@ApiModelProperty(value = "授课机构或人员")
	private String teachParty;

	@ApiModelProperty(value = "实施开始时间")
	private Date stime;

	@ApiModelProperty(value = "实施结束时间")
	private Date etime;

	@ApiModelProperty(value = "培训形式")
	private String trainForm;

	@ApiModelProperty(value = "评价方式")
	private String evaluateForm;

	@ApiModelProperty(value = "是否删除0否1是")
	private Integer deleted;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "培训主题")
	private String trainTopic;

	@ApiModelProperty(value = "培训内容")
	private String trainContent;

	@ApiModelProperty(value = "培训对象")
	private String trainObjects;

	@ApiModelProperty(value = "培训地点")
	private String trainArea;

	@ApiModelProperty(value = "培训有效性确认")
	private String trainEntrue;

	@ApiModelProperty(value = "确认人")
	private String confirmor;

	@ApiModelProperty(value = "确认时间")
	private Date confirTime;

	@ApiModelProperty("状态 0草稿1待审核2已通过")
	private Integer status;

	@ApiModelProperty("temp")
	private Integer temp;



}
