package com.patzn.lims.staff.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 人员培训记录附件表
 * </p>
 *
 * @author patzn
 * @since 2018-07-17
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffTrainRecordAttachment extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "公司 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "培训记录id")
	private Long recordId;

    @ApiModelProperty(value = "文件名")
	private String fileName;

    @ApiModelProperty(value = "桶名称")
	private String bucketName;

    @ApiModelProperty(value = "对象 key")
	private String objectKey;

    @ApiModelProperty(value = "版本号")
	private String versionId;

    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "文件类型")
	private String type;

    @ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;


}
