package com.patzn.lims.staff.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 人员培训记录管理人员表
 * </p>
 *
 * @author patzn
 * @since 2018-07-17
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffTrainRecordRelUser extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "人员id")
	private Long personId;

    @ApiModelProperty(value = "人员名称")
	private String person;

    @ApiModelProperty(value = "培训记录id")
	private Long recordId;

    @ApiModelProperty(value = "工号")
	private String workNumber;

    @ApiModelProperty(value = "总结")
	private String summary;

    @ApiModelProperty(value = "分数")
	private BigDecimal score;

    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "是否删除0否1是")
	private Integer deleted;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;


}
