package com.patzn.lims.staff.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.equip.dto.LmsEquipInfoDTO;
import com.patzn.lims.equip.vo.LmsEquipInfoVO;
import com.patzn.lims.staff.entity.LmsStaffInfo;
import com.patzn.lims.staff.vo.LmsStaffInfoVO;
import com.patzn.lims.staff.vo.LmsStaffTrainRecordVO;
import org.apache.ibatis.annotations.Param;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * <p>
  * 人员管理-人员基本信息 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
public interface LmsStaffInfoMapper extends BaseMapper<LmsStaffInfo> {

    @SqlParser(filter = true)
    List<LmsStaffInfoVO> selectPageVO(Page page, @Param("ew") LmsStaffInfoVO lmsStaffInfoVO);

    List<LmsStaffInfoVO> selectPageVO(@Param("ew") LmsStaffInfoVO lmsStaffInfoVO);

    LmsStaffInfoVO selectVOById(@Param("id") Long id);

    @SqlParser(filter = true)
    List<LmsStaffInfoVO> getInfoByOrg(Page page, @Param("ids") List<Long> ids, @Param("vo") LmsStaffInfoVO lmsStaffInfo);

    List<LmsStaffTrainRecordVO>  getEduList(Page page, @Param("vo") LmsStaffTrainRecordVO lmsStaffTrainRecordVO);

    @SqlParser(filter = true)
    List<LmsEquipInfoVO> selectPageEq(Page page, @Param("account") Account account, @Param("ew") LmsEquipInfoDTO lmsEquipInfoDTO);


    @SqlParser(filter = true)
    List<LmsEquipInfoVO> selectPageEquip(Page page, @Param("account") Account account, @Param("ew") LmsEquipInfoDTO lmsEquipInfoDTO);

    @SqlParser(filter = true)
    List<LmsStaffInfoVO> getStaffList(@Param("ids") List<Long> ids, @Param("vo") LmsStaffInfoVO lmsStaffInfo);

    List<LmsStaffInfo>selectListExpire();

    List<LmsStaffInfo>selectBecomeMsg();
}