package com.patzn.lims.staff.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.equip.dto.LmsEquipInfoDTO;
import com.patzn.lims.equip.vo.LmsEquipInfoVO;
import com.patzn.lims.staff.dto.LmsStaffInfoDTO;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffInfo;
import com.patzn.lims.staff.vo.LmsStaffInfoVO;
import com.patzn.lims.staff.vo.LmsStaffTrainRecordVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 人员管理-人员基本信息 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
public interface ILmsStaffInfoService extends IBaseService<LmsStaffInfo> {

    Page<LmsStaffInfoVO> pageVO(Page<LmsStaffInfoVO> page, LmsStaffInfoVO lmsStaffInfoVO);

    List<LmsStaffInfoVO> listVO(LmsStaffInfoVO lmsStaffInfoVO);

    LmsStaffInfoVO getVOById(Long id);

    Boolean edit(LmsStaffInfoDTO lmsStaffInfoDTO);

    Boolean add(LmsStaffInfoDTO lmsStaffInfoDTO);


    boolean importItem(MultipartFile file);

    boolean removeAllRel(Long[] ids);

    LmsStaffFile uploadFile(MultipartFile file, Long relId, Integer type);

    Boolean deleteFile(Long id);

    LmsStaffInfoVO  temp();

    Page<LmsStaffInfoVO>  getListByOrg(Page<LmsStaffInfoVO> page, LmsStaffInfoVO lmsStaffInfo);

    Page<LmsStaffTrainRecordVO>  getEduList(Page<LmsStaffTrainRecordVO> page, LmsStaffTrainRecordVO lmsStaffTrainRecordVO);

    Page<LmsEquipInfoVO> pageEq(Page<LmsEquipInfoVO> page, LmsEquipInfoDTO lmsEquipInfoDTO);

    List<LmsStaffInfoVO>  getStaffList(LmsStaffInfoVO lmsStaffInfo);

    void lmsStaffInfoExpireMsg();

    void lmsStaffInfoBecomeMsg();

}
