package com.patzn.lims.staff.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffProfessional;
import com.patzn.lims.staff.vo.LmsStaffProfessionalVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 人员管理-人员职称 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
public interface ILmsStaffProfessionalService extends IBaseService<LmsStaffProfessional> {

    Page<LmsStaffProfessionalVO> pageVO(Page<LmsStaffProfessionalVO> page, LmsStaffProfessionalVO lmsStaffProfessionalVO);

    List<LmsStaffProfessionalVO> listVO(LmsStaffProfessionalVO lmsStaffProfessionalVO);

    LmsStaffProfessionalVO getVOById(Long id);

    Boolean add(LmsStaffProfessionalVO lmsStaffProfessional);

    Boolean del(Long[] ids);

    Boolean edit(LmsStaffProfessionalVO lmsStaffProfessionalVO);

    LmsStaffProfessionalVO temp();

    Boolean deleteFile(Long id);

    LmsStaffFile uploadFile(MultipartFile file, Long relId, Integer type);

    /**
     * 证书到期提醒
     */
    void sendMsg();
}
