package com.patzn.lims.staff.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.staff.dto.LmsStaffScheduleDTO;
import com.patzn.lims.staff.entity.LmsStaffSchedule;
import com.patzn.lims.staff.vo.LmsStaffScheduleVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 人员管理-人员排班 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
public interface ILmsStaffScheduleService extends IBaseService<LmsStaffSchedule> {

    Page<LmsStaffScheduleVO> pageVO(Page<LmsStaffScheduleVO> page, LmsStaffScheduleDTO lmsStaffScheduleDTO);

    List<LmsStaffScheduleVO> listVO(LmsStaffScheduleDTO lmsStaffScheduleDTO);

    List<LmsStaffScheduleVO> getPageDepartPerson(LmsStaffScheduleVO scheduleVO, Long departId);

    LmsStaffScheduleVO geVOById(Long id);

    boolean saveAndCheck(LmsStaffSchedule lmsStaffSchedule);

    boolean importItem(MultipartFile file, Account account);
}
