package com.patzn.lims.staff.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffTrainRecord;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordAttachment;
import com.patzn.lims.staff.vo.LmsStaffTrainRecordVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 人员管理-人员培训记录 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
public interface ILmsStaffTrainRecordService extends IBaseService<LmsStaffTrainRecord> {

    Page<LmsStaffTrainRecordVO> pageVO(Page<LmsStaffTrainRecordVO> page, LmsStaffTrainRecordVO lmsStaffTrainRecordVO);

    List<LmsStaffTrainRecordVO> listVO(LmsStaffTrainRecordVO lmsStaffTrainRecordVO);

    LmsStaffTrainRecordVO getVOById(Long id);

    Boolean edit(LmsStaffTrainRecord lmsStaffTrainRecord);

    Boolean add(LmsStaffTrainRecord lmsStaffTrainRecord);

    LmsStaffFile upload(String bucketName, MultipartFile file, LmsStaffTrainRecord record);

    Boolean deleteFile(Long id);

    void   exportPersonTrain(HttpServletResponse response, Long id);

    void   exportPersonSelfTrain(HttpServletResponse response, Long id);

    LmsStaffTrainRecordAttachment uploadAttachment(String bucketName, MultipartFile file, LmsStaffTrainRecord record);

    LmsStaffTrainRecordVO  temp();




}
