package com.patzn.lims.staff.service.impl;



import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.staff.entity.LmsStaffCertificateAttachment;
import com.patzn.lims.staff.mapper.LmsStaffCertificateAttachmentMapper;
import com.patzn.lims.staff.service.ILmsStaffCertificateAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 证书编号附件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-06-27
 */
@Service
public class LmsStaffCertificateAttachmentServiceImpl extends BaseServiceImpl<LmsStaffCertificateAttachmentMapper, LmsStaffCertificateAttachment> implements ILmsStaffCertificateAttachmentService {

    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsStaffCertificateAttachment> page(Page<LmsStaffCertificateAttachment> page, LmsStaffCertificateAttachment lmsStaffCertificateAttachment) {
        QueryWrapper wrapper = Wrappers. <LmsStaffCertificateAttachment>query(lmsStaffCertificateAttachment);
        return page(page, wrapper);
    }


    @Override
    public List<LmsStaffCertificateAttachment> list(LmsStaffCertificateAttachment lmsStaffCertificateAttachment) {
        return list(Wrappers. <LmsStaffCertificateAttachment>query(lmsStaffCertificateAttachment));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(Long certificateId, MultipartFile file) {
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return false;
        }
        // 文件类型，版本信息
        LmsStaffCertificateAttachment attachment = new LmsStaffCertificateAttachment();
        attachment.setType(result.getType());
        attachment.setCertificateId(certificateId);
        attachment.setBucketName(result.getBucketName());
        attachment.setObjectKey(result.getObjectKey());
        attachment.setVersionId(result.getVersionId());
        // 上传新文件
        int length = result.getName().length();
        if (length > 99) {
            StringBuilder fileName = new StringBuilder();
            fileName.append(result.getName().substring(0, 50));
            fileName.append(result.getName().substring(length - 50));
            attachment.setFileName(fileName.toString());
        } else {
            attachment.setFileName(result.getName());
        }
        return super.save(attachment);
    }

    @Override
    public void download(Long id, HttpServletResponse response) {
        LmsStaffCertificateAttachment attachment = super.getById(id);
        if (null == attachment) {
            PtAssert.fail("抱歉！该附件不存在");
        }
        ossClient.download(attachment.getObjectKey(), response);
    }
}
