package com.patzn.lims.staff.service.impl;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.staff.entity.LmsStaffCertificate;
import com.patzn.lims.staff.mapper.LmsStaffCertificateMapper;
import com.patzn.lims.staff.service.ILmsStaffCertificateService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 人员证书表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-06-27
 */
@Service
public class LmsStaffCertificateServiceImpl extends BaseServiceImpl<LmsStaffCertificateMapper, LmsStaffCertificate> implements ILmsStaffCertificateService {


    @Override
    public Page<LmsStaffCertificate> page(Page<LmsStaffCertificate> page, LmsStaffCertificate vo) {
        if (null==vo.getStaffId()){
            PtAssert.fail("人员id未传递");
        }

        return page.setRecords(baseMapper.selectLmsStaffCertificateVOList(page,vo));
    }


    @Override
    public List<LmsStaffCertificate> list(LmsStaffCertificate lmsStaffCertificate) {
        return list(Wrappers.<LmsStaffCertificate>query(lmsStaffCertificate));
    }
}
