package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.staff.entity.LmsStaffEquip;
import com.patzn.lims.staff.mapper.LmsStaffEquipMapper;
import com.patzn.lims.staff.service.ILmsStaffEquipService;
import com.patzn.lims.staff.vo.LmsStaffEquipVO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 人员管理-人员关联检测仪器 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Service
public class LmsStaffEquipServiceImpl extends BaseServiceImpl<LmsStaffEquipMapper, LmsStaffEquip> implements ILmsStaffEquipService {

    @Override
    public Page<LmsStaffEquipVO> pageVO(Page<LmsStaffEquipVO> page, LmsStaffEquipVO lmsStaffEquipVO) {
        return page.setRecords(baseMapper.selectPageVO(page, lmsStaffEquipVO));
    }


    @Override
    public List<LmsStaffEquipVO> listVO(LmsStaffEquipVO lmsStaffEquipVO) {
        return baseMapper.selectPageVO(lmsStaffEquipVO);
    }


    @Override
    public LmsStaffEquipVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean addBatch(Long id, Long[] ids) {
        //先删除再保存
        try {
            baseMapper.delete(Wrappers.<LmsStaffEquip>query().eq("staff_id", id));
            List<LmsStaffEquip> list = new ArrayList<>();
            for (Long equipId:ids) {
                LmsStaffEquip lmsStaffEquip=new LmsStaffEquip();
                lmsStaffEquip.setStaffId(id);
                lmsStaffEquip.setEquipId(equipId);
                list.add(lmsStaffEquip);
            }
            this.saveBatch(list);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

    }
}
