package com.patzn.lims.staff.service.impl;




import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.mapper.LmsStaffFileMapper;
import com.patzn.lims.staff.service.ILmsStaffFileService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * <p>
 * 人员管理文件信息表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-05-15
 */
@Service
public class LmsStaffFileServiceImpl extends BaseServiceImpl<LmsStaffFileMapper, LmsStaffFile> implements ILmsStaffFileService {


    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsStaffFile> page(Page<LmsStaffFile> page, LmsStaffFile lmsStaffFile) {
       QueryWrapper wrapper  = Wrappers.<LmsStaffFile>query(lmsStaffFile);

        return page(page, wrapper);
    }


    @Override
    public List<LmsStaffFile> list(LmsStaffFile lmsStaffFile) {
        return list(Wrappers.<LmsStaffFile>query(lmsStaffFile));
    }

    @Override
    public LmsStaffFile saveAndUpload(MultipartFile file, String bucketName, String foldPath, Long relId, Integer type) {
        OssFileResult ossFileResult = ossClient.upload(file);
        if (null == ossFileResult) {
            return null;
        }
        LmsStaffFile lmsStaffFile = new LmsStaffFile();
        lmsStaffFile.setRelId(relId);
        lmsStaffFile.setFileOrginName(file.getOriginalFilename());
        lmsStaffFile.setFileUrl(ossFileResult.getObjectKey());
        lmsStaffFile.setType(type);
        lmsStaffFile.setCompanyId(LoginHelper.getAccount().getCompanyId());
        save(lmsStaffFile);
        return lmsStaffFile;
    }

    @Override
    public boolean deleteBatch(Long[] ids) {
        List<LmsStaffFile> staffFileList = list(Wrappers.<LmsStaffFile>query().in("id", ids));
        if (CollectionUtils.isEmpty(staffFileList)) {
            return false;
        }
        ossClient.deleteObjects(staffFileList.stream().map(e -> e.getFileUrl()).collect(toList()));
        return remove(Wrappers.<LmsStaffFile>query().in("id", ids));
    }

    @Override
    public void updateFiles(List<Long> ids, Long id) {
        baseMapper.updteFiles(ids, id);
    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        LmsStaffFile lmsStaffFile = getById(id);
        PtAssert.fail(null == lmsStaffFile, "文件不存在！");
        String fileUrl = lmsStaffFile.getFileUrl();
        String orgFileName = lmsStaffFile.getFileOrginName().replaceAll("\\s*", "");
        ossClient.download(fileUrl, orgFileName, response);
    }


}
