package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.staff.entity.LmsStaffLevel;
import com.patzn.lims.staff.mapper.LmsStaffLevelMapper;
import com.patzn.lims.staff.service.ILmsStaffLevelService;
import com.patzn.lims.staff.vo.LmsStaffLevelVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 人员管理-人员等级分类 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Service
public class LmsStaffLevelServiceImpl extends BaseServiceImpl<LmsStaffLevelMapper, LmsStaffLevel> implements ILmsStaffLevelService {

    @Override
    public Page<LmsStaffLevelVO> page(Page<LmsStaffLevelVO> page, LmsStaffLevelVO vo) {
        if (null != vo.getId()) {
            // 递归分页情况
            return this.pageRecursive(page, vo);
        }
        return page.setRecords(baseMapper.selectPageVO(page,vo));
    }


    @Override
    public Page<LmsStaffLevelVO> pageRecursive(Page<LmsStaffLevelVO> page, LmsStaffLevelVO vo) {
        return page.setRecords(baseMapper.selectPageRecursive(page, vo));
    }

    @Override
    public List<LmsStaffLevel> list(LmsStaffLevel lmsStaffLevel) {
        lmsStaffLevel.setDeleted(0);
       QueryWrapper wrapper  = Wrappers.<LmsStaffLevel>query(lmsStaffLevel);
        if (null != lmsStaffLevel.getName()){
            wrapper.like("name", lmsStaffLevel.getName());
            lmsStaffLevel.setName(null);
        }
        return this.list(wrapper);
    }

    @Override
    public LmsStaffLevelVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public Boolean add(LmsStaffLevel lmsStaffLevel) {
        if (StringUtils.isNotBlank(lmsStaffLevel.getName())){
            LmsStaffLevel level = new LmsStaffLevel();
            level.setName(lmsStaffLevel.getName());
            Integer count = baseMapper.selectExist(level);
            if (count > 0) {
                PtAssert.fail("类型名称已存在，不可重复");
            }
        }

        if (StringUtils.isNotBlank(lmsStaffLevel.getCode())){
            LmsStaffLevel level = new LmsStaffLevel();
            level.setCode(lmsStaffLevel.getCode());
            Integer count = baseMapper.selectExist(level);
            if (count > 0) {
                PtAssert.fail("类型编号已存在，不可重复");
            }
        }
        return save(lmsStaffLevel);
    }

    @Override
    public Boolean edit(LmsStaffLevel lmsStaffLevel) {
        if (StringUtils.isNotBlank(lmsStaffLevel.getName())){
            LmsStaffLevel level = new LmsStaffLevel();
            level.setId(lmsStaffLevel.getId());
            level.setName(lmsStaffLevel.getName());
            Integer count = baseMapper.selectExist(level);
            if (count > 0) {
                PtAssert.fail("等级名称已存在，不可重复");
            }
        }

        if (StringUtils.isNotBlank(lmsStaffLevel.getCode())){
            LmsStaffLevel level = new LmsStaffLevel();
            level.setId(lmsStaffLevel.getId());
            level.setCode(lmsStaffLevel.getCode());
            Integer count = baseMapper.selectExist(level);
            if (count > 0) {
                PtAssert.fail("等级编号已存在，不可重复");
            }
        }
        return updateById(lmsStaffLevel);
    }

    @Override
    public List<LmsStaffLevel> listAllRank(LmsStaffLevel level) {
        return list(level);
    }
}
