package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffProfessional;
import com.patzn.lims.staff.mapper.LmsStaffProfessionalMapper;
import com.patzn.lims.staff.service.ILmsStaffFileService;
import com.patzn.lims.staff.service.ILmsStaffProfessionalService;
import com.patzn.lims.staff.vo.LmsStaffProfessionalVO;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 人员管理-人员职称 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Service
public class LmsStaffProfessionalServiceImpl extends BaseServiceImpl<LmsStaffProfessionalMapper, LmsStaffProfessional> implements ILmsStaffProfessionalService {

    @Autowired
    private ILmsStaffFileService lmsStaffFileService;
    @Autowired
    private OssClient ossClient;
    @Autowired
    private AmqpTemplate amqpTemplate;
//    @Autowired
//    private MqProperties mqProperties;

    @Override
    public Page<LmsStaffProfessionalVO> pageVO(Page<LmsStaffProfessionalVO> page, LmsStaffProfessionalVO lmsStaffProfessionalVO) {
        return page.setRecords(baseMapper.selectPageVO(page, lmsStaffProfessionalVO));
    }

    @Override
    public List<LmsStaffProfessionalVO> listVO(LmsStaffProfessionalVO lmsStaffProfessionalVO) {
        return baseMapper.selectPageVO(lmsStaffProfessionalVO);
    }

    @Override
    public LmsStaffProfessionalVO getVOById(Long id) {
        //文件集合，展示用
        List<LmsStaffFile> fileList = lmsStaffFileService.list(Wrappers.<LmsStaffFile>query().eq("rel_id", id));
        for (LmsStaffFile e:fileList) {
            e.setFileUrl(ossClient.getUrl(e.getFileUrl()).toString());
        }
        LmsStaffProfessionalVO lmsStaffProfessionalVO = baseMapper.selectVOById(id);
        lmsStaffProfessionalVO.setFileList(fileList);
        return lmsStaffProfessionalVO;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean add(LmsStaffProfessionalVO lmsStaffProfessional) {
        LmsStaffProfessional staffProfessional = lmsStaffProfessional.convert(LmsStaffProfessional.class);
        Boolean result = this.save(staffProfessional);
        List<Long> list = lmsStaffProfessional.fileIdList();
        if (list != null) {
            lmsStaffFileService.updateFiles(list, staffProfessional.getId());
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean del(Long[] ids) {
        try {
            lmsStaffFileService.remove(Wrappers.<LmsStaffFile>query().in("rel_id", ids));
            this.remove(Wrappers.<LmsStaffProfessional>query().in("id", ids));
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean edit(LmsStaffProfessionalVO lmsStaffProfessionalVO) {
        try {
            updateById(lmsStaffProfessionalVO);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

    }

    @Override
    public LmsStaffProfessionalVO temp() {
        LmsStaffProfessionalVO lmsStaffProfessionalVO = new LmsStaffProfessionalVO();
        List<LmsStaffFile> list = new ArrayList<>();
        LmsStaffProfessional lmsStaffProfessional = this.getOne(Wrappers.<LmsStaffProfessional>query().eq("temp_status", 0));
        if (lmsStaffProfessional == null) {
            LmsStaffProfessional info = new LmsStaffProfessional();
            this.save(info);
            lmsStaffProfessionalVO.setId(info.getId());
            lmsStaffProfessionalVO.setFileList(list);
            return lmsStaffProfessionalVO;
        } else {
            list = lmsStaffFileService.list(Wrappers.<LmsStaffFile>query().eq("rel_id", lmsStaffProfessional.getId()));
            lmsStaffProfessionalVO.setId(lmsStaffProfessional.getId());
            lmsStaffProfessionalVO.setFileList(list);
            return lmsStaffProfessionalVO;
        }
    }

    @Override
    public Boolean deleteFile(Long id) {
        try {
            LmsStaffFile lmsStaffFile = lmsStaffFileService.getById(id);
            ossClient.deleteObject(lmsStaffFile.getFileUrl());
            lmsStaffFileService.removeById(id);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public LmsStaffFile uploadFile(MultipartFile file, Long relId, Integer type) {
        OssFileResult ossFileResult = ossClient.upload(file);
        if (null == ossFileResult) {
            return null;
        }
        LmsStaffFile lmsStaffFile = new LmsStaffFile();
        lmsStaffFile.setFileOrginName(file.getOriginalFilename());
        lmsStaffFile.setFileUrl(ossFileResult.getObjectKey());
        lmsStaffFile.setType(type);
        lmsStaffFile.setCompanyId(LoginHelper.getAccount().getCompanyId());
        if (relId != 0) {
            lmsStaffFile.setRelId(relId);
        }
        lmsStaffFileService.save(lmsStaffFile);
        //回显数据
        lmsStaffFile.setFileUrl(ossClient.getUrl(ossFileResult.getObjectKey()).toString());
        return lmsStaffFile;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void sendMsg() {
//        try {
//            List<LmsStaffProfessionalVO> list = baseMapper.overDate();
//            List<Long> willList = new ArrayList<>();
//            List<Long> overList = new ArrayList<>();
//            list.forEach(e -> {
//                if (e.getOverDays() < 0 && e.getStaffId() != null) {
//                    overList.add(e.getStaffId());
//                } else if (e.getOverDays() > 0 && e.getStaffId() != null) {
//                    willList.add(e.getStaffId());
//                }
//            });
//            if (willList.size() > 0) {
//                MqMsg willMsg = new MqMsg();
//                willMsg.setUid(LoginHelper.getAccount().getUserId());
//                willMsg.setCompanyId(LoginHelper.getAccount().getCompanyId());
//                willMsg.setSender(LoginHelper.getAccount().getUserName());
//                willMsg.setTitle("证书即将到期提醒");
//                willMsg.setContent("证书即将到期，请及时处理！");
//                willMsg.setType(1);
//                willMsg.setSender("系统发送");
//                willMsg.setReceiverIds(willList);
//                amqpTemplate.convertAndSend(mqProperties.getTopic().getPushMsg(), willMsg);
//            }
//            if (overList.size() > 0) {
//                MqMsg overMsg = new MqMsg();
//                overMsg.setUid(LoginHelper.getAccount().getUserId());
//                overMsg.setCompanyId(LoginHelper.getAccount().getCompanyId());
//                overMsg.setSender(LoginHelper.getAccount().getUserName());
//                overMsg.setTitle("证书超期提醒");
//                overMsg.setContent("证书已超期，请及时处理！");
//                overMsg.setType(1);
//                overMsg.setSender("系统发送");
//                overMsg.setReceiverIds(willList);
//                amqpTemplate.convertAndSend(mqProperties.getTopic().getPushMsg(), overMsg);
//            }
//        } catch (AmqpException e) {
//            logger.error("证书提示消息失败", e);
//        }
    }


}
