package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.cloud.commons.toolkit.DateUtils;
import com.patzn.lims.staff.entity.LmsStaffRelOrg;
import com.patzn.lims.staff.mapper.LmsStaffRelOrgMapper;
import com.patzn.lims.staff.service.ILmsStaffRelOrgService;
import com.patzn.lims.staff.service.ILmsStaffScheduleService;
import com.patzn.lims.staff.vo.LmsStaffScheduleTaskVO;
import com.patzn.lims.staff.vo.LmsStaffScheduleVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 人员关联部门表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-05-14
 */
@Service
public class LmsStaffRelOrgServiceImpl extends BaseServiceImpl<LmsStaffRelOrgMapper, LmsStaffRelOrg> implements ILmsStaffRelOrgService {
    @Autowired
    private ILmsStaffScheduleService lmsStaffScheduleService;

    @Override
    public Page<LmsStaffRelOrg> page(Page<LmsStaffRelOrg> page, LmsStaffRelOrg lmsStaffRelOrg) {
       QueryWrapper wrapper  = Wrappers.<LmsStaffRelOrg>query(lmsStaffRelOrg);

        return this.page(page, wrapper);
    }


    @Override
    public List<LmsStaffRelOrg> list(LmsStaffRelOrg lmsStaffRelOrg) {
        return this.list(Wrappers.<LmsStaffRelOrg>query(lmsStaffRelOrg));
    }

    @Override
    public List<LmsStaffScheduleTaskVO> getDepartmentPersonSchedule(LmsStaffScheduleVO scheduleVO) {

        List<LmsStaffRelOrg> relOrgList = baseMapper.selectDepartmentList(scheduleVO, LoginHelper.getAccount().getCompanyId());
        List<LmsStaffScheduleTaskVO> scheduleTaskVOS = new ArrayList<>();
        for (LmsStaffRelOrg relOrg : relOrgList) {
            List<LmsStaffScheduleVO> scheduleVOList = lmsStaffScheduleService.getPageDepartPerson(scheduleVO, relOrg.getOrgId());
            if (CollectionUtils.isNotEmpty(scheduleVOList)) {
                List<Long> listDateLong = new LinkedList<>();
                Date minBegin = scheduleVOList.get(0).getScheduleStartTime();
                Date maxEnd = scheduleVOList.get(0).getScheduleEndTime();
                for (LmsStaffScheduleVO vo : scheduleVOList) {
                    LmsStaffScheduleTaskVO taskVO = new LmsStaffScheduleTaskVO();
                    taskVO.setId(IdWorker.getId());


                    if (relOrg.getOrgId().equals(Long.parseLong("0"))) {
                        taskVO.setParent(1111111111L);
                    } else {
                        taskVO.setParent(relOrg.getOrgId());
                    }

                    taskVO.setProgress(0);
                    taskVO.setStartDate(vo.getScheduleStartTime());
                    taskVO.setText(vo.getStaffName());
                    taskVO.setDuration(DateUtils.getDaysBetweenTwoDate(vo.getScheduleStartTime(), vo.getScheduleEndTime()));
                    taskVO.setEndDate(vo.getScheduleEndTime());
                    if (null != vo.getScheduleStartTime()) {
                        listDateLong.add(vo.getScheduleStartTime().getTime());
                    }
                    if (null != vo.getScheduleEndTime()) {
                        listDateLong.add(vo.getScheduleEndTime().getTime());
                    }
                    scheduleTaskVOS.add(taskVO);
                    if (vo.getScheduleEndTime().after(maxEnd)) {
                        maxEnd = vo.getScheduleEndTime();    // 判断最大值
                    }
                    if (vo.getScheduleStartTime().before(minBegin)) {
                        minBegin = vo.getScheduleStartTime();      // 判断最小值
                    }
                }
                LmsStaffScheduleTaskVO relTaskVO = new LmsStaffScheduleTaskVO();
                relTaskVO.setText(relOrg.getOrgName());
                relTaskVO.setProgress(0);
                if (relOrg.getOrgId().equals(Long.parseLong("0"))) {
                    relTaskVO.setId(1111111111L);
                } else {
                    relTaskVO.setId(relOrg.getOrgId());
                }
                relTaskVO.setOpen(true);
//            relTaskVO.setDuration(DateUtils.getDaysInListLong(listDateLong));
//            if (CollectionUtils.isNotEmpty(listDateLong)) {
//                relTaskVO.setStartDate(DateUtils.getMinDateInDateLongList(listDateLong));
//            }
                relTaskVO.setDuration(DateUtils.getDaysBetweenTwoDate(minBegin, maxEnd));
                relTaskVO.setStartDate(minBegin);
                relTaskVO.setEndDate(maxEnd);
                scheduleTaskVOS.add(relTaskVO);
            }
        }
        return scheduleTaskVOS;
    }

}
