package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.DateUtils;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.excel.eto.LmsStaffScheduleETO;
import com.patzn.lims.staff.dto.LmsStaffScheduleDTO;
import com.patzn.lims.staff.entity.LmsStaffInfo;
import com.patzn.lims.staff.entity.LmsStaffSchedule;
import com.patzn.lims.staff.mapper.LmsStaffScheduleMapper;
import com.patzn.lims.staff.service.ILmsStaffInfoService;
import com.patzn.lims.staff.service.ILmsStaffScheduleService;
import com.patzn.lims.staff.vo.LmsStaffScheduleVO;
import com.patzn.poibox.utils.ExcelUtils;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 人员管理-人员排班 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Service
public class LmsStaffScheduleServiceImpl extends BaseServiceImpl<LmsStaffScheduleMapper, LmsStaffSchedule> implements ILmsStaffScheduleService {

    @Autowired
    private ILmsStaffInfoService lmsStaffInfoService;

    @Override
    public Page<LmsStaffScheduleVO> pageVO(Page<LmsStaffScheduleVO> page, LmsStaffScheduleDTO lmsStaffScheduleDTO) {
        lmsStaffScheduleDTO.setCompanyId(LoginHelper.getAccount().getCompanyId());
        return page.setRecords(baseMapper.selectPageVO(page, lmsStaffScheduleDTO));
    }

    @Override
    public List<LmsStaffScheduleVO> listVO(LmsStaffScheduleDTO lmsStaffScheduleDTO) {
        return baseMapper.selectPageVO(lmsStaffScheduleDTO);
    }

    @Override
    public List<LmsStaffScheduleVO> getPageDepartPerson(LmsStaffScheduleVO scheduleVO, Long departId) {

        return baseMapper.selectDepartPersonVO(scheduleVO, departId, LoginHelper.getAccount().getCompanyId());
    }

    @Override
    public LmsStaffScheduleVO geVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveAndCheck(LmsStaffSchedule lmsStaffSchedule) {
        int count = super.count(Wrappers.<LmsStaffSchedule>query().eq("staff_id", lmsStaffSchedule.getStaffId()).eq("schedule_start_time", lmsStaffSchedule.getScheduleStartTime()));
        PtAssert.fail(count > 0, "该人员在当前日期内已有排班，请勿重复添加");
        return super.save(lmsStaffSchedule);
    }


    @Override
    public boolean importItem(MultipartFile file, Account account) {
        Collection<LmsStaffScheduleETO> etos = ExcelUtils.readSheetAtOne(LmsStaffScheduleETO.class, file, "导入人员排班信息失败");
        if (CollectionUtils.isEmpty(etos)) {
            return false;
        }
        List<LmsStaffSchedule> lmsStaffSchedules = new ArrayList<>();
        for (LmsStaffScheduleETO eto : etos) {
            PtAssert.fail(StringUtils.isBlank(eto.getNumber()), "请填写工号！");
            PtAssert.fail(StringUtils.isBlank(eto.getName()), "请填写人员姓名！");
            //判断录入人员是否存在，不存在直接保存
            List<LmsStaffInfo> list = lmsStaffInfoService.list(Wrappers.<LmsStaffInfo>query().eq("name", eto.getName()).eq("number", eto.getNumber()).eq("status", 1));
            //说明排班的人系统中不存在
            PtAssert.fail(list.size() == 0, "只能给人员管理中存在的'在职'人员排班！");
        }
        for (LmsStaffScheduleETO eto : etos) {
            LmsStaffSchedule schedule = new LmsStaffSchedule();
            List<LmsStaffInfo> list2 = lmsStaffInfoService.list(Wrappers.<LmsStaffInfo>query().eq("name", eto.getName()).eq("number", eto.getNumber()));
            if (list2.size() == 1) {
                schedule.setStaffId(list2.get(0).getId());
            }
            if (StringUtil.isNotBlank(eto.getRemark())) {
                schedule.setRemark(eto.getRemark());
            }
            if (StringUtil.isNotBlank(eto.getScheduleStartTime())) {
                schedule.setScheduleStartTime(DateUtils.toDate(eto.getScheduleStartTime()));
            }
            if (StringUtil.isNotBlank(eto.getScheduleEndTime())) {
                schedule.setScheduleEndTime(DateUtils.toDate(eto.getScheduleEndTime()));
            }
            if (StringUtil.isNotBlank(eto.getShift())) {
                if (eto.getShift().equals("早班")) {
                    schedule.setShift(0);
                } else if (eto.getShift().equals("中班")) {
                    schedule.setShift(1);
                } else if (eto.getShift().equals("晚班")) {
                    schedule.setShift(2);
                }
            }
            lmsStaffSchedules.add(schedule);
        }
        this.saveBatch(lmsStaffSchedules);
        return true;
    }
}
