package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.staff.entity.LmsStaffStatus;
import com.patzn.lims.staff.mapper.LmsStaffStatusMapper;
import com.patzn.lims.staff.service.ILmsStaffStatusService;
import com.patzn.lims.staff.vo.LmsStaffStatusRecordVO;
import com.patzn.lims.staff.vo.LmsStaffStatusVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 人员管理-人员状态 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Service
public class LmsStaffStatusServiceImpl extends BaseServiceImpl<LmsStaffStatusMapper, LmsStaffStatus> implements ILmsStaffStatusService {

    @Override
    public Page<LmsStaffStatusVO> pageVO(Page<LmsStaffStatusVO> page, LmsStaffStatusVO lmsStaffStatusVO) {
        return page.setRecords(baseMapper.selectPageVO(page, lmsStaffStatusVO));
    }

    @Override
    public List<LmsStaffStatusVO> listVO(LmsStaffStatusVO lmsStaffStatusVO) {
        return baseMapper.selectPageVO(lmsStaffStatusVO);

    }

    @Override
    public LmsStaffStatusVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public List<LmsStaffStatusVO> calendarList(LmsStaffStatusVO lmsStaffStatusVO) {
        return baseMapper.selectCalendarList(lmsStaffStatusVO);
    }

    @Override
    public boolean updateStaffStatus(LmsStaffStatus lmsStaffStatus) {
        updateById(lmsStaffStatus);
        return true;
    }

    @Override
    public Page<LmsStaffStatusRecordVO> pageStaffStatusRecordVO(Page<LmsStaffStatusRecordVO> page, LmsStaffStatusRecordVO lmsStaffStatusRecordVO) {
        return page.setRecords(baseMapper.selectPageRecordVO(page, lmsStaffStatusRecordVO));
    }

    @Override
    public Boolean add(LmsStaffStatus lmsStaffStatus) {
    List<LmsStaffStatus> list =  this.list(Wrappers.<LmsStaffStatus>query().eq("staff_id",lmsStaffStatus.getStaffId()).eq("work_date",lmsStaffStatus.getWorkDate()));
    PtAssert.fail(list.size()>0, "人员的状态已存在！");
    return this.save(lmsStaffStatus);
    }
}
