package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.staff.entity.LmsStaffTrainPlan;
import com.patzn.lims.staff.entity.LmsStaffTrainPlanAttachment;
import com.patzn.lims.staff.mapper.LmsStaffTrainPlanAttachmentMapper;
import com.patzn.lims.staff.service.ILmsStaffTrainPlanAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 人员培训计划附件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-20
 */
@Service
public class LmsStaffTrainPlanAttachmentServiceImpl extends BaseServiceImpl<LmsStaffTrainPlanAttachmentMapper, LmsStaffTrainPlanAttachment> implements ILmsStaffTrainPlanAttachmentService {

    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsStaffTrainPlanAttachment> page(Page<LmsStaffTrainPlanAttachment> page, LmsStaffTrainPlanAttachment lmsStaffTrainPlanAttachment) {
       QueryWrapper wrapper  = Wrappers.<LmsStaffTrainPlanAttachment>query(lmsStaffTrainPlanAttachment);
        return page(page, wrapper);
    }


    @Override
    public List<LmsStaffTrainPlanAttachment> list(LmsStaffTrainPlanAttachment lmsStaffTrainPlanAttachment) {
        return list(Wrappers.<LmsStaffTrainPlanAttachment>query(lmsStaffTrainPlanAttachment));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(Long trainPlanId, MultipartFile file) {
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return false;
        }
        // 文件类型，版本信息
        LmsStaffTrainPlanAttachment attachment = new LmsStaffTrainPlanAttachment();
        attachment.setType(result.getType());
        attachment.setTrainPlanId(trainPlanId);
        attachment.setBucketName(result.getBucketName());
        attachment.setObjectKey(result.getObjectKey());
        attachment.setVersionId(result.getVersionId());
        // 上传新文件
        int length = result.getName().length();
        if (length > 99) {
            StringBuilder fileName = new StringBuilder();
            fileName.append(result.getName().substring(0, 50));
            fileName.append(result.getName().substring(length - 50));
            attachment.setFileName(fileName.toString());
        } else {
            attachment.setFileName(result.getName());
        }
        return super.save(attachment);
    }

    @Override
    public void download(Long id, HttpServletResponse response) {
        LmsStaffTrainPlanAttachment attachment = super.getById(id);
        if (null == attachment) {
            PtAssert.fail("抱歉！该附件不存在");
        }
        ossClient.download(attachment.getObjectKey(), response);

    }


    @Override
    public LmsStaffTrainPlanAttachment saveAndUpload(MultipartFile file, LmsStaffTrainPlan plan) {
        OssFileResult ossFileResult = ossClient.upload(file);
        if (null == ossFileResult) {
            return null;
        }
        LmsStaffTrainPlanAttachment attachment = new LmsStaffTrainPlanAttachment();
        attachment.setTrainPlanId(plan.getId());
        attachment.setFileName(file.getOriginalFilename());
        attachment.setObjectKey(ossFileResult.getObjectKey());
        attachment.setType(file.getOriginalFilename().split("\\.")[1]);
        attachment.setCompanyId(LoginHelper.getAccount().getCompanyId());
        save(attachment);
        //文件路径
        attachment.setObjectKey(ossClient.getUrl(attachment.getObjectKey()).toString());
        return attachment;
    }

    @Override
    public Boolean deleteFile(Long id) {
        LmsStaffTrainPlanAttachment attachment = getOne(Wrappers.<LmsStaffTrainPlanAttachment>query().eq("id", id));
        if (null == attachment) {
            return false;
        }
        ossClient.deleteObject(attachment.getObjectKey());
        return remove(Wrappers.<LmsStaffTrainPlanAttachment>query().eq("id", id));
    }
}
