package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordAttachment;
import com.patzn.lims.staff.mapper.LmsStaffTrainRecordAttachmentMapper;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 人员培训记录附件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-17
 */
@Service
public class LmsStaffTrainRecordAttachmentServiceImpl extends BaseServiceImpl<LmsStaffTrainRecordAttachmentMapper, LmsStaffTrainRecordAttachment> implements ILmsStaffTrainRecordAttachmentService {

    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsStaffTrainRecordAttachment> page(Page<LmsStaffTrainRecordAttachment> page, LmsStaffTrainRecordAttachment lmsStaffTrainRecordAttachment) {
       QueryWrapper wrapper  = Wrappers.<LmsStaffTrainRecordAttachment>query(lmsStaffTrainRecordAttachment);
        return page(page, wrapper);
    }


    @Override
    public List<LmsStaffTrainRecordAttachment> list(LmsStaffTrainRecordAttachment lmsStaffTrainRecordAttachment) {
        return list(Wrappers.<LmsStaffTrainRecordAttachment>query(lmsStaffTrainRecordAttachment));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(Long recordId, MultipartFile file) {
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return false;
        }
        // 文件类型，版本信息
        LmsStaffTrainRecordAttachment attachment = new LmsStaffTrainRecordAttachment();
        attachment.setType(result.getType());
        attachment.setRecordId(recordId);
        attachment.setBucketName(result.getBucketName());
        attachment.setObjectKey(result.getObjectKey());
        attachment.setVersionId(result.getVersionId());
        // 上传新文件
        int length = result.getName().length();
        if (length > 99) {
            StringBuilder fileName = new StringBuilder();
            fileName.append(result.getName().substring(0, 50));
            fileName.append(result.getName().substring(length - 50));
            attachment.setFileName(fileName.toString());
        } else {
            attachment.setFileName(result.getName());
        }
        return super.save(attachment);
    }

    @Override
    public void download(Long id, HttpServletResponse response) {
        LmsStaffTrainRecordAttachment attachment = super.getById(id);
        if (null == attachment) {
            PtAssert.fail("抱歉！该附件不存在");
        }
        ossClient.download(attachment.getObjectKey(), response);

    }

    @Override
    public LmsStaffTrainRecordAttachment saveAndUpload(MultipartFile file, String bucketName, String foldPath, Long relId, Integer type) {
        OssFileResult ossFileResult = ossClient.upload(file);
        if (null == ossFileResult) {
            return null;
        }
        LmsStaffTrainRecordAttachment attachment = new LmsStaffTrainRecordAttachment();
        if(null ==relId){
            attachment.setRecordId(0l);
        }else{
            attachment.setRecordId(relId);
        }
        attachment.setFileName(file.getOriginalFilename());
        attachment.setObjectKey(ossFileResult.getObjectKey());
        attachment.setType(attachment.getFileName().split("\\.")[1]);
        attachment.setCompanyId(LoginHelper.getAccount().getCompanyId());
        save(attachment);
        //文件路径
        attachment.setObjectKey(ossClient.getUrl(attachment.getObjectKey()).toString());
        return attachment;
    }


    @Override
    public boolean deleteAttachment(Long id) {
        LmsStaffTrainRecordAttachment attachment = getOne(Wrappers.<LmsStaffTrainRecordAttachment>query().eq("id", id));
        if (null == attachment) {
            return false;
        }
        ossClient.deleteObject(attachment.getObjectKey());
        return remove(Wrappers.<LmsStaffTrainRecordAttachment>query().eq("id", id));
    }
}
