package com.patzn.lims.staff.service.impl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordRelUser;
import com.patzn.lims.staff.mapper.LmsStaffTrainRecordRelUserMapper;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordRelUserService;
import com.patzn.lims.staff.vo.LmsStaffTrainRecordRelUserVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 人员培训记录管理人员表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-17
 */
@Service
public class LmsStaffTrainRecordRelUserServiceImpl extends BaseServiceImpl<LmsStaffTrainRecordRelUserMapper, LmsStaffTrainRecordRelUser> implements ILmsStaffTrainRecordRelUserService {


    @Override
    public Page<LmsStaffTrainRecordRelUserVO> page(Page<LmsStaffTrainRecordRelUserVO> page, LmsStaffTrainRecordRelUserVO lmsStaffTrainRecordRelUser) {
        PtAssert.fail(null==lmsStaffTrainRecordRelUser.getRecordId(),"请选择培训记录");
        return page.setRecords(baseMapper.selectPageVO(page,lmsStaffTrainRecordRelUser));
    }


    @Override
    public List<LmsStaffTrainRecordRelUser> list(LmsStaffTrainRecordRelUser lmsStaffTrainRecordRelUser) {
        return this.list(Wrappers.<LmsStaffTrainRecordRelUser>query(lmsStaffTrainRecordRelUser));
    }


    @Override
    public boolean saveRelUser(LmsStaffTrainRecordRelUser relUser) {
        PtAssert.fail(null==relUser.getRecordId(),"请选择培训计划");
        PtAssert.fail(null==relUser.getPersonId(),"系统中不存在该人员");
        int count=count(Wrappers.<LmsStaffTrainRecordRelUser>query().eq("record_id",relUser.getRecordId()).
        eq("person_id",relUser.getPersonId()));
        PtAssert.fail(count>0,"您选择的人员已经在本次培训记录中，请勿重复选择");
        return save(relUser);
    }
}
