package com.patzn.lims.staff.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.excel.eto.LmsStaffTrainETO;
import com.patzn.lims.excel.handler.LmsStaffTrainRecordPersonExportHandler;
import com.patzn.lims.res.service.ILmsPropertyService;
import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffTrainRecord;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordAttachment;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordLog;
import com.patzn.lims.staff.mapper.LmsStaffTrainRecordMapper;
import com.patzn.lims.staff.service.ILmsStaffFileService;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordAttachmentService;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordLogService;
import com.patzn.lims.staff.service.ILmsStaffTrainRecordService;
import com.patzn.lims.staff.vo.LmsStaffTrainRecordVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 人员管理-人员培训记录 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Service
public class LmsStaffTrainRecordServiceImpl extends BaseServiceImpl<LmsStaffTrainRecordMapper, LmsStaffTrainRecord> implements ILmsStaffTrainRecordService {


    @Autowired
    private ILmsStaffFileService lmsStaffFileService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsStaffTrainRecordLogService lmsStaffTrainRecordLogService;

    @Autowired
    private ILmsStaffTrainRecordAttachmentService lmsStaffTrainRecordAttachmentService;


    @Override
    public Page<LmsStaffTrainRecordVO> pageVO(Page<LmsStaffTrainRecordVO> page, LmsStaffTrainRecordVO lmsStaffTrainRecordVO) {
        return page.setRecords(baseMapper.selectPageVO(page, lmsStaffTrainRecordVO));
    }

    @Override
    public List<LmsStaffTrainRecordVO> listVO(LmsStaffTrainRecordVO lmsStaffTrainRecordVO) {
        return baseMapper.selectPageVO(lmsStaffTrainRecordVO);
    }

    @Override
    public LmsStaffTrainRecordVO getVOById(Long id) {
        LmsStaffTrainRecordVO vo = baseMapper.selectVOById(id);
        if (null != vo) {
            List<LmsStaffTrainRecordAttachment> attachments = lmsStaffTrainRecordAttachmentService.list(Wrappers.<LmsStaffTrainRecordAttachment>query().eq("record_id", id));
            vo.setAttachments(attachments);
        }
        return vo;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean edit(LmsStaffTrainRecord lmsStaffTrainRecord) {
        PtAssert.fail(null == lmsStaffTrainRecord.getId(), "更新id不能为空");
        LmsStaffTrainRecord old = getById(lmsStaffTrainRecord.getId());
        if (old.getTemp() == 1) {
            String remark = lmsPropertyService.getObjectCompareDifferent(lmsStaffTrainRecord, old, "人员培训记录对比", "人员培训记录信息修改：");
            if (StringUtils.isNotBlank(remark)) {
                LmsStaffTrainRecordLog recordLog = new LmsStaffTrainRecordLog();
                recordLog.setTarget("修改培训记录");
                //recordLog.setLiable(LoginHelper.getAccount().getUserName());
                recordLog.setOperator(LoginHelper.getAccount().getUserName());
                recordLog.setRecordId(old.getId());
                recordLog.setType(2);
                recordLog.setRemark(remark);
                lmsStaffTrainRecordLogService.save(recordLog);
            }
        } else {
            lmsStaffTrainRecord.setStatus(0);
            lmsStaffTrainRecord.setTemp(1);
        }
        return updateById(lmsStaffTrainRecord);
    }


    @Override
    public Boolean add(LmsStaffTrainRecord lmsStaffTrainRecord) {
        PtAssert.fail(null == lmsStaffTrainRecord.getTrainId(), "请选择培训计划！");
        return save(lmsStaffTrainRecord);
    }

    @Override
    public LmsStaffFile upload(String bucketName, MultipartFile file, LmsStaffTrainRecord record) {
        Long companyId = LoginHelper.getAccount().getCompanyId();
        String foldPath = "staff/trainRecord/" + companyId + "/";
        return lmsStaffFileService.saveAndUpload(file, "lims", foldPath, record.getId(), 0);
    }

    @Override
    public Boolean deleteFile(Long id) {
        return lmsStaffTrainRecordAttachmentService.deleteAttachment(id);
    }

    @Override
    public void exportPersonTrain(HttpServletResponse response, Long id) {
        PtAssert.fail(null == id, "导出数据参数不能为空");
        List<LmsStaffTrainETO> itemList = baseMapper.selectEtoByRecordId(id, LoginHelper.getAccount().getCompanyId());
        if (CollectionUtils.isNotEmpty(itemList)) {
            new LmsStaffTrainRecordPersonExportHandler(itemList).generater(response);
        }
    }

    @Override
    public void exportPersonSelfTrain(HttpServletResponse response, Long id) {
        PtAssert.fail(null == id, "导出数据参数不能为空");
        List<LmsStaffTrainETO> itemList = baseMapper.selectEtoByPersonId(id, LoginHelper.getAccount().getCompanyId());
        if (CollectionUtils.isNotEmpty(itemList)) {
            new LmsStaffTrainRecordPersonExportHandler(itemList).generater(response);
        }
    }

    @Override
    public LmsStaffTrainRecordAttachment uploadAttachment(String bucketName, MultipartFile file, LmsStaffTrainRecord record) {
        Long companyId = LoginHelper.getAccount().getCompanyId();
        String foldPath = "staff/trainRecord/" + companyId + "/";
        return lmsStaffTrainRecordAttachmentService.saveAndUpload(file, "lims", foldPath, record.getId(), 0);
    }

    @Override
    public LmsStaffTrainRecordVO temp() {
        LmsStaffTrainRecordVO trainRecordVO = new LmsStaffTrainRecordVO();
        List<LmsStaffTrainRecordAttachment> list = new ArrayList<>();
        LmsStaffTrainRecord trainRecord = this.getOne(Wrappers.<LmsStaffTrainRecord>query().eq("temp", 0).eq("uid",LoginHelper.getAccount().getUserId()));
        if (trainRecord == null) {
            LmsStaffTrainRecord record = new LmsStaffTrainRecord();
            record.setTemp(0);
            this.save(record);
            trainRecordVO.setId(record.getId());
            trainRecordVO.setAttachments(list);
            return trainRecordVO;
        } else {
            list = lmsStaffTrainRecordAttachmentService.list(Wrappers.<LmsStaffTrainRecordAttachment>query().eq("record_id", trainRecord.getId()));
            trainRecordVO.setId(trainRecord.getId());
            trainRecordVO.setAttachments(list);
            return trainRecordVO;
        }
    }


}
