package com.patzn.lims.staff.vo;

import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffProfessional;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 人员管理-人员职称
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffProfessionalVO extends LmsStaffProfessional {

	private String staffName;

	private String keyword;

	@ApiModelProperty(value = "附件集合")
	private String fileIds;

	public List<Long> fileIdList() {
		if (StringUtils.isEmpty(this.fileIds)) {
			return null;
		}
		String[] fileIdArr = this.fileIds.split(",");
		List<Long> fileIdList = new ArrayList<>();
		for (String fileId : fileIdArr) {
			fileIdList.add(Long.valueOf(fileId));
		}
		return fileIdList;
	}

	List<LmsStaffFile> fileList;
}
