package com.patzn.lims.staff.vo;

import com.patzn.lims.staff.entity.LmsStaffFile;
import com.patzn.lims.staff.entity.LmsStaffTrainRecord;
import com.patzn.lims.staff.entity.LmsStaffTrainRecordAttachment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 人员管理-人员培训记录
 * </p>
 *
 * @author patzn
 * @since 2017-11-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStaffTrainRecordVO extends LmsStaffTrainRecord {

	private String trainName;

	private Date trainDate;

	private Date startDate;

	private Date endDate;

	private List<LmsStaffFile> lmsStaffFiles;

	private List<LmsStaffTrainRecordAttachment>  attachments;

	@ApiModelProperty(value = "备注")
	private String  remark;
	@ApiModelProperty(value = "分数")
	private BigDecimal score;
	@ApiModelProperty(value = "总结")
	private String  summary;
	@ApiModelProperty(value = "人员id")
	private Long  uid;
}
