package com.patzn.lims.stomp;

import org.joda.time.DateTime;

/**
 * <p>
 * Web Socket 消息
 * </p>
 *
 * @author hubin
 * @since 2018-01-02
 */
public class WsMsg {

    public static final String TOPIC_NOTICE = "/topic/notice";
    public static final String TOPIC_MESSAGE = "/topic/message";

    /**
     * 环境生成报告的用于进度条的改变
     */
    public static final String TOPIC_REPORT_MAKE = "/topic/report/make";

    /**
     * 消息ID
     */
    private Long id;
    /**
     * 消息类型
     */
    private int type;
    /**
     * 消息内容
     */
    private String content;
    /**
     * 发送者
     */
    private String sender;
    /**
     * 发送时间
     */
    private Long time;


    public WsMsg() {

    }


    public WsMsg(String content, String sender) {
        this(null, WsMsgType.NOTICE, content, sender);
    }


    public WsMsg(Long id, WsMsgType type, String content, String sender) {
        this(id, type.getType(), content, sender);
    }


    public WsMsg(Long id, int type, String content, String sender) {
        this.id = id;
        this.type = type;
        this.content = content;
        this.sender = sender;
        this.time = DateTime.now().getMillis();
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public Long getTime() {
        return time;
    }

    public void setTime(Long time) {
        this.time = time;
    }
}
