package com.patzn.lims.sys.controller;

import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.toolkit.Barcode4jUtils;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.sys.service.ISysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;

/**
 * <p>
 * 绘图控制器
 * </p>
 */
@Slf4j
@Api(tags = "绘图相关")
@RestController
@RequestMapping("/v1/canvas")
public class CanvasController extends SuperController {
    @Autowired
    private ISysUserService sysUserService;

    @ApiOperation(value = "条形码生成", notes = "生成指定 code 条形码生成")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "编码内容", required = true, paramType = "path", dataType = "Long"),
    })
    @GetMapping("/bar-code/{code}")
    public void barCode(@PathVariable("code") String code) {
        try {
            Barcode4jUtils.generate(code, response.getOutputStream());
        } catch (IOException e) {
            log.error("生成 BarCode 异常", e);
            PtAssert.fail("生成条形码异常，请联系管理员");
        }
    }

    @ApiOperation(value = "生成二维码", notes = "生成指定内容二维码")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "contents", value = "生成内容", required = true, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "width", value = "宽（可选，必须与高同时存在）", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "height", value = "高（可选，必须与宽同时存在）", paramType = "query", dataType = "Integer"),
    })
    @GetMapping("/qr-code")
    public void qrCode(@RequestParam String contents, Integer width, Integer height) {
        sysUserService.qrCode(contents, width, height, response);
    }

    @ApiOperation(value = "用户 ID 的 OTP 二维码", notes = "生成指定用户 ID OTP 二维码，未指定当前用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "生成内容", required = true, paramType = "query", dataType = "Long"),
    })
    @GetMapping("/otp-code")
    public void otpCode(@RequestParam Long userId) {
        sysUserService.otpQrCode(response, 282, 282, userId);
    }
}
