package com.patzn.lims.sys.controller;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.sys.service.IEmailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 邮件发送控制器
 * </p>
 *
 * @author hubin
 * @since 2018-04-26
 */
@Api(tags = "电子邮箱相关")
@RestController
@RequestMapping("/v1/email")
public class EmailController extends SuperController {

    @Autowired
    private IEmailService emailService;


    @ApiOperation(value = "发送校验码", notes = "发送绑定邮箱校验码")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "email", value = "邮箱", required = true, paramType = "query", dataType = "String"),
    })
    @PostMapping("/send")
    public PtResult<Boolean> send(@RequestParam String email) {
        return success(emailService.sendValidCode(request, getAccount(), email));
    }


    @ApiOperation(value = "绑定邮箱", notes = "根据校验码绑定激活邮箱")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "校验码", required = true, paramType = "path", dataType = "String"),
    })
    @PostMapping("/bind-{code}")
    public PtResult<Boolean> bind(@PathVariable("code") String code) {
        return success(emailService.bindByCode(getAccount(), code));
    }
}
