package com.patzn.lims.sys.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.sys.enums.VerificationCodeEnum;
import com.patzn.lims.sys.service.ISmsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 短信发送控制器
 * </p>
 *
 * @author hubin
 * @since 2018-04-26
 */
@Api(tags = "短信相关")
@RestController
@RequestMapping("/v1/sms")
public class SmsController extends SuperController {
    @Autowired
    private ISmsService smsService;

    @ApiOperation(value = "发送短信验证码", notes = "给指定手机号码发送发送短信验证码")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "module", value = "模块", required = true, paramType = "path", dataType = "String"),
            @ApiImplicitParam(name = "mobile", value = "手机号码", required = true, paramType = "path", dataType = "String"),
    })
    @Login(action = Action.Skip)
    @PostMapping("/send-{module}/{mobile}")
    public PtResult<Boolean> sendSms(@PathVariable("module") String module, @PathVariable("mobile") String mobile) {
        return success(smsService.sendValidCode(request, LoginHelper.getAccount(request, false),
                module, mobile));
    }

    @ApiOperation(value = "绑定手机号", notes = "根据校验码绑定手机号")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "校验码", required = true, paramType = "path", dataType = "String"),
    })
    @PostMapping("/bind-{code}")
    public PtResult<Boolean> bind(@PathVariable("code") String code) {
        return success(smsService.bindByCode(VerificationCodeEnum.BIND_MOBILE, getAccount(), code));
    }


    @ApiOperation(value = "更换绑定手机号", notes = "根据校验码更换绑定手机号")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "校验码", required = true, paramType = "path", dataType = "String"),
    })
    @PostMapping("/change-bind-{code}")
    public PtResult<Boolean> changeBind(@PathVariable("code") String code) {
        return success(smsService.bindByCode(VerificationCodeEnum.BIND_CHANGE_MOBILE, getAccount(), code));
    }
}
