package com.patzn.lims.sys.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysArea;
import com.patzn.lims.sys.service.ISysAreaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 地区表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-07-20
 */
@Api(tags = "地区表")
@RestController
@RequestMapping("/v1/area")
public class SysAreaController extends ServiceController<ISysAreaService, SysArea> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysArea>> getPage(SysArea sysArea) {
        this.haveSystemPermissions();
        return success(baseService.page(getPage(), sysArea));
    }

    @ApiOperation(value = "根据城市ID查询列表", notes = "根据城市ID查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "cityId", value = "城市ID", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @PostMapping("/list-{cityId}")
    public PtResult<List<Map<String, Object>>> getListByCityCode(@PathVariable("cityId") Long cityId) {
        return success(baseService.listByCityId(cityId));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysArea sysArea) {
        this.haveSystemPermissions();
        return success(baseService.updateById(sysArea));
    }
}
