package com.patzn.lims.sys.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysCity;
import com.patzn.lims.sys.service.ISysCityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 城市 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-07-20
 */
@Api(tags = "城市表")
@RestController
@RequestMapping("/v1/city")
public class SysCityController extends ServiceController<ISysCityService, SysCity> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysCity>> getPage(SysCity sysCity) {
        this.haveSystemPermissions();
        return success(baseService.page(getPage(), sysCity));
    }

    @Login(action = Action.Skip)
    @Cacheable(value = "10minutes", key = "'listByProvinceCode' + #code")
    @ApiOperation(value = "根据省份Code查询列表", notes = "根据省份Code查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "省份 CODE", required = true, paramType = "path", dataType = "String"),
    })
    @PostMapping("/list-all-{code}")
    public PtResult<List<SysCity>> getListByProvinceId(@PathVariable("code") String code) {
        return success(baseService.listByProvinceCode(code));
    }

    @ApiOperation(value = "根据省份ID查询列表", notes = "根据省份ID查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "provinceId", value = "省份ID", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @PostMapping("/list-{provinceId}")
    public PtResult<List<Map<String, Object>>> getListByProvinceId(@PathVariable("provinceId") Long provinceId) {
        return success(baseService.listByProvinceId(provinceId));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysCity sysCity) {
        this.haveSystemPermissions();
        return success(baseService.updateById(sysCity));
    }
}
