package com.patzn.lims.sys.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysCompany;
import com.patzn.lims.sys.entity.SysCompanyRelSystem;
import com.patzn.lims.sys.service.ISysCompanyRelSystemService;
import com.patzn.lims.sys.service.ISysCompanyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 公司表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-07-20
 */
@Api(tags = "公司表")
@RestController
@RequestMapping("/v1/company")
public class SysCompanyController extends ServiceController<ISysCompanyService, SysCompany> {
    @Autowired
    private ISysCompanyRelSystemService sysCompanyRelSystemService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysCompany>> getPage(SysCompany sysCompany) {
        haveSystemPermissions();
        return success(baseService.page(getPage(), sysCompany));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysCompany>> getList(SysCompany sysCompany) {
        haveSystemPermissions();
        return success(baseService.list(sysCompany));
    }


    @ApiOperation(value = "分配系统", notes = "添加企业系统关联关系")
    @PostMapping("/rel-system/{companyId}")
    public PtResult<Boolean> addRelSystem(@PathVariable("companyId") Long companyId, @RequestParam("systemIds") Long[] systemIds) {
        haveSystemPermissions();
        return success(sysCompanyRelSystemService.addRelSystem(companyId, systemIds));
    }


    @ApiOperation(value = "关联系统", notes = "查询企业已经关联的系统列表")
    @GetMapping("/get-rel-system/{companyId}")
    public PtResult<List<SysCompanyRelSystem>> getRelSystem(@PathVariable("companyId") Long companyId) {
        haveSystemPermissions();
        return success(sysCompanyRelSystemService.getRelSystem(companyId));
    }


    @ApiOperation(value = "查询我的企业信息", notes = "查询当前用户所属企业的数据内容")
    @GetMapping("/my")
    public PtResult<Map<String, Object>> companyInfo() {
        return success(baseService.getMyCompanyInfo(getAccount()));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysCompany sysCompany) {
        haveSystemPermissions();
        return success(baseService.updateById(sysCompany));
    }



    @Login(action = Action.Skip)
    @ApiOperation(value = "修改联盟企业", notes = "添加一条数据")
    @GetMapping("/update_union/{id}/{unionCompanyId}/{unionCompanyName}")
    public PtResult<String> updateUnion(@PathVariable("id")Long id, @PathVariable("unionCompanyId")Long unionCompanyId, @PathVariable("unionCompanyName")String unionCompanyName) {
        SysCompany sysCompany=new SysCompany();
        sysCompany.setId(id);
        sysCompany.setUnionCompany(unionCompanyName);
        sysCompany.setUnionCompanyId(unionCompanyId);
        if (baseService.updateById(sysCompany)){
            return success("0");
        }else{
            return success("1");
        }

    }




    @Override
    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(SysCompany sysCompany) {
        haveSystemPermissions();
        return success(baseService.save(sysCompany));
    }


    @Login(action = Action.Skip)
    @ApiOperation(value = "设置 LOGO", notes = "设置企业 LOGO")
    @PostMapping("/logo-{companyId}")
    public PtResult<String> saveLogo(MultipartFile file, @PathVariable("companyId") Long companyId) {
        return success(baseService.saveLogo(companyId, file));
    }


//    @Login(action = Action.Skip)
//    @ApiOperation(value = "显示 LOGO", notes = "显示企业 LOGO")
//    @GetMapping("/logo")
//    public void showLogo(@RequestParam String key) {
//        ossClient.display(key, response);
//    }
}
