package com.patzn.lims.sys.controller;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.sys.service.ISysCompanyRelModuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 公司模块关联表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-03-07
 */
@Api(tags = "公司模块关联表")
@RestController
@RequestMapping("/v1/company-rel-module")
public class SysCompanyRelModuleController extends SuperController {

    @Autowired
    private ISysCompanyRelModuleService sysCompanyRelModuleService;


    @ApiOperation(value = "企业添加模块管理", notes = "添加企业添加模块管理数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "companyId", value = "企业 ID", required = true, paramType = "path", dataType = "Long"),
            @ApiImplicitParam(name = "moduleIds", value = "模块主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/{companyId}")
    public PtResult<Boolean> add(@PathVariable("companyId") Long companyId, @RequestParam("moduleIds") Long[] moduleIds) {
        return success(sysCompanyRelModuleService.save(companyId, moduleIds));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "companyId", value = "企业 ID", required = true, paramType = "path", dataType = "Long"),
            @ApiImplicitParam(name = "moduleIds", value = "模块主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/{companyId}")
    public PtResult<Boolean> delete(@PathVariable("companyId") Long companyId, @RequestParam("moduleIds") Long[] moduleIds) {
        return success(sysCompanyRelModuleService.remove(companyId, moduleIds));
    }
}
